  try {
      //print(dataToInsert);
      await db.insert('empowerment_data', dataToInsert);
    } on DatabaseException catch (e) {
      if (e.isNoSuchTableError()) {
        // Create table if not exists
        //await _initDb();
      await db.execute('''
        CREATE TABLE empowerment_data (
          id TEXT PRIMARY KEY,
          regionId TEXT,
          districtId TEXT,
          wardId TEXT,
          villageId TEXT,
          full_name TEXT,
          organization TEXT,
          position TEXT,
          contact_info TEXT,
          email TEXT,
          relationship_to_youth_empowerment TEXT,
          economic_challenges_facing_youth TEXT,
          available_opportunities TEXT,
          other_opportunity TEXT,
          opportunity_barriers TEXT,
          other_barrier TEXT,
          youth_have_skills TEXT,
          why_lack_skills TEXT,
          available_training_programs TEXT,
          in_demand_skills TEXT,
          support_services TEXT,
          accessibility TEXT,
          youth_led_orgs TEXT,
          empowerment_suggestions TEXT,
          implementation_challenges TEXT,
          is_sent INTEGER DEFAULT 0,
          created_at TEXT DEFAULT (datetime('now'))
        )
      ''');
        final newDb = await database;

        //print(dataToInsert);
        // Retry insert
        await newDb.insert('empowerment_data', dataToInsert);
      } else {
        rethrow;
      }
    }